/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.sfp.srvutil;

import com.ibm.hsc.auiml.databeans.sfp.srvutil.IdentifyLEDEnclosureBean;
import com.ibm.hsc.auiml.databeans.sfp.srvutil.IdentifyLEDFruBean;
import com.ibm.hsc.auiml.databeans.sfp.srvutil.IdentifyLEDStruct;
import com.ibm.hsc.auiml.databeans.sfp.srvutil.ServiceUtilConstants;
import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.ccfw.mom.PIFrame;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCFrameClient;
import com.ibm.hsc.client.PILEDDataBean;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.websm.sfp.SFPUtil;
import com.ibm.hsc.websm.sfp.ServiceUtilitiesTarget;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruConfig;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetedTasklet;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class IdentifyLEDTasklet
extends TargetedTasklet
implements ServiceUtilConstants {
    private static final String TRACE_MASKD = "JIDXLEDD";
    private static final String TRACE_MASKF = "JIDXLEDF";
    private static final String TRACE_MASKT = "JIDXLEDT";
    private static final String AUIML_FILE_NAME = "com.ibm.hsc.auiml.databeans.sfp.srvutil.IdentifyLED";
    private static final String INITIAL_PANEL = "IdentifyLEDEnclosurePanel";
    private static final String FRU_PANEL = "IdentifyLEDFRUPanel";
    private static final LocalizableText BUSY_LED_TITLE_1 = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_LED_TITLE_1");
    private static final LocalizableText BUSY_LED_TITLE_2 = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_LED_TITLE_2");
    private static final LocalizableText BUSY_LED_TEXT_1 = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_LED_TEXT_1");
    private static final LocalizableText BUSY_LED_TEXT_2 = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_LED_TEXT_2");
    private static final LocalizableText BUSY_LED_TEXT_3 = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_LED_TEXT_3");
    private static final LocalizableText BUSY_LED_TEXT_4 = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_LED_TEXT_4");
    private static final LocalizableText BUSY_LED_TEXT_5 = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_LED_TEXT_5");
    private static final String CMD_LINE_BUNDLE = "PIHscCmdLineBundle";
    private static final String ENCL = "encl";
    private static final String SYS_TAG = "sys";
    public static final int CMD_ACTIVATE = 1;
    public static final int CMD_DEACTIVATE = 0;
    public static final int ENCLOSURE_DESC = 0;
    public static final int FRU_DESC = 1;
    private String selSystem = null;
    private String userDefinedName = null;
    private PIHSCCECClient r5Client = null;
    private PIHSCFrameClient r5fClient = null;
    private boolean TargetIsACec;
    private static final short ERRID_0040 = 64;
    private static final short ERRID_0041 = 65;
    private static final short ERRID_0042 = 66;
    private static final short ERRID_0043 = 67;
    private static final short ERRID_0044 = 68;
    private static final short ERRID_0045 = 69;
    private static final short ERRID_0046 = 70;
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, -128, "SFPUtilIdLED");
    private static final int SPECIFIED_SINGLE_INDICATOR = 2;
    private static final int ALL_INDICATORS_IN_SPECIFIED_ENCLOSURES = 1;
    private static final int ALL_INDICATORS_SYSTEM = 0;

    public IdentifyLEDTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> IdentifyLEDTasklet c-tor");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> IdentifyLEDTasklet.service()");
        if (panelTaskletRequest.isInitialRequest()) {
            Trace.trace((String)TRACE_MASKF, (Object)"-> IdentifyLEDTasklet.isInitialRequest()");
            IdentifyLEDEnclosureBean identifyLEDEnclosureBean = new IdentifyLEDEnclosureBean();
            identifyLEDEnclosureBean.setBeanName("IdentifyLEDEnclosureBean");
            Target[] targetArray = this.getSelectedTargets();
            this.selSystem = targetArray[0].getName().toString();
            Object object = ((ServiceUtilitiesTarget)targetArray[0]).getTargetObject();
            if (object instanceof PICec || object instanceof PIFrame) {
                if (object instanceof PICec) {
                    this.userDefinedName = ((PICec)object).getUserDefinedName();
                    this.TargetIsACec = true;
                    Trace.trace((String)TRACE_MASKF, (Object)"-- target selected is a CEC");
                } else {
                    this.userDefinedName = ((PIFrame)object).getUserDefinedName();
                    this.TargetIsACec = false;
                    Trace.trace((String)TRACE_MASKF, (Object)"-- target selected is a Frame");
                }
                Trace.trace((String)TRACE_MASKF, (Object)("-- selected system is: " + this.selSystem + ", user defined name is: " + this.userDefinedName));
                if (this.selSystem != null && this.selSystem.length() != 0) {
                    identifyLEDEnclosureBean.setSelectedSystem(this.selSystem);
                }
                try {
                    this.showBusyDialog(BUSY_LED_TITLE_1, BUSY_LED_TEXT_1);
                    ArrayList arrayList = this.getAllEnclosureInfo(this.userDefinedName);
                    if (arrayList != null && arrayList.size() > 0) {
                        this.setDescriptions(arrayList, this.selSystem, 0);
                        identifyLEDEnclosureBean.setEnclosureIdentifyLEDStruct(arrayList);
                    }
                    panelTaskletResponse.openModalChild(AUIML_FILE_NAME, INITIAL_PANEL, (PanelBean)identifyLEDEnclosureBean);
                    this.destroyBusyDialog();
                }
                catch (Exception exception) {
                    String string;
                    Trace.trace((String)TRACE_MASKD, (Object)("-- exception during initial service request, e is " + exception));
                    this.destroyBusyDialog();
                    new AusMicrocodeLog(_logInfo, 65, exception).writeEntry(null);
                    if (exception.getMessage().equals("CIMNullClient")) {
                        string = "0242";
                    } else if (exception instanceof UnknownHostException) {
                        string = "0241";
                    } else if (exception instanceof PIHscClientException) {
                        String string2 = ((PIHscClientException)exception).getMsgId();
                        Trace.trace((String)TRACE_MASKF, (Object)("-- PIHscClientException msg ID is " + string2));
                        string = string2.equals("0238") ? "0238" : "0243";
                    } else {
                        string = "0245";
                    }
                    SFPUtil.showSFPErrorMessageBox(string, (PanelTasklet)this);
                    try {
                        panelTaskletResponse.openModalChild(AUIML_FILE_NAME, INITIAL_PANEL, (PanelBean)identifyLEDEnclosureBean);
                    }
                    catch (Exception exception2) {
                        Trace.trace((String)TRACE_MASKF, (Object)("Another exception caught during initial service request, e1 is " + exception2));
                        panelTaskletResponse.terminate();
                    }
                }
            } else {
                panelTaskletResponse.noAction();
            }
            Trace.trace((String)TRACE_MASKF, (Object)"<- IdentifyLEDTasklet.isInitialRequest()");
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)("taskletRequest.getData(event): " + panelTaskletRequest.getData("event") + "."));
            if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                Trace.trace((String)TRACE_MASKF, (Object)"taskletRequest.isDisposed() or isCanceled, issue taskletResponse.dispose().");
                panelTaskletResponse.dispose();
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"Some taskletRequest other than Cancel is pending.");
                String string = (String)panelTaskletRequest.getData("Command");
                String string3 = (String)panelTaskletRequest.getData("Source");
                if (string3 == null) {
                    string3 = "";
                }
                Trace.trace((String)TRACE_MASKF, (Object)("--> source=" + string3));
                if (string3.equals("")) {
                    Trace.trace((String)TRACE_MASKF, (Object)"Unspecified source");
                    panelTaskletResponse.noAction();
                } else if (string3.equals(INITIAL_PANEL)) {
                    IdentifyLEDEnclosureBean identifyLEDEnclosureBean = (IdentifyLEDEnclosureBean)panelTaskletRequest.getData("DataBean");
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("Command", string);
                    hashMap.put("Source", string3);
                    hashMap.put("DataBean", identifyLEDEnclosureBean);
                    if (string == null) {
                        string = "";
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)("--> command=" + string));
                    if (string.equals("")) {
                        Trace.trace((String)TRACE_MASKF, (Object)"Unspecified command");
                        panelTaskletResponse.noAction();
                    } else if (string.equals("RefreshEnclosurePanelButton")) {
                        try {
                            this.showBusyDialog(BUSY_LED_TITLE_1, BUSY_LED_TEXT_1);
                            ArrayList arrayList = this.getAllEnclosureInfo(this.userDefinedName);
                            if (arrayList != null && arrayList.size() > 0) {
                                this.setDescriptions(arrayList, this.selSystem, 0);
                                identifyLEDEnclosureBean.setEnclosureIdentifyLEDStruct(arrayList);
                            }
                            hashMap.put("Command", "refreshEnclTable");
                            panelTaskletResponse.update(identifyLEDEnclosureBean.getBeanName(), hashMap);
                            this.destroyBusyDialog();
                        }
                        catch (Exception exception) {
                            Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught -> " + exception));
                            panelTaskletResponse.noAction();
                            this.destroyBusyDialog();
                        }
                    } else if (string.equals("ActivateEnclosureLEDButton")) {
                        String string4 = identifyLEDEnclosureBean.getSelectedEnclosureLocationCode();
                        this.serviceIdentifyLEDEnclosureCmd(string4, 1);
                        ArrayList arrayList = identifyLEDEnclosureBean.getEnclosureIdentifyLEDStruct();
                        this.showBusyDialog(BUSY_LED_TITLE_1, BUSY_LED_TEXT_5);
                        this.updateILS(arrayList, string4);
                        identifyLEDEnclosureBean.setEnclosureIdentifyLEDStruct(arrayList);
                        hashMap.put("Command", "refreshEnclTable");
                        panelTaskletResponse.update(identifyLEDEnclosureBean.getBeanName(), hashMap);
                        this.destroyBusyDialog();
                    } else if (string.equals("DeactivateEnclosureLEDButton")) {
                        String string5 = identifyLEDEnclosureBean.getSelectedEnclosureLocationCode();
                        if (this.IsFruLedLit(string5)) {
                            Trace.trace((String)TRACE_MASKF, (Object)"-- FRU LED active.");
                            SFPUtil.showSFPInfoMessageBox("0255", (PanelTasklet)this);
                            panelTaskletResponse.noAction();
                        } else {
                            this.serviceIdentifyLEDEnclosureCmd(string5, 0);
                            ArrayList arrayList = identifyLEDEnclosureBean.getEnclosureIdentifyLEDStruct();
                            this.showBusyDialog(BUSY_LED_TITLE_1, BUSY_LED_TEXT_5);
                            this.updateILS(arrayList, string5);
                            identifyLEDEnclosureBean.setEnclosureIdentifyLEDStruct(arrayList);
                            hashMap.put("Command", "refreshEnclTable");
                            panelTaskletResponse.update(identifyLEDEnclosureBean.getBeanName(), hashMap);
                            this.destroyBusyDialog();
                        }
                    } else if (string.equals("SelectedMenu.ListFRUs")) {
                        IdentifyLEDFruBean identifyLEDFruBean = new IdentifyLEDFruBean();
                        identifyLEDFruBean.setBeanName("IdentifyLEDFruBean");
                        try {
                            this.showBusyDialog(BUSY_LED_TITLE_1, BUSY_LED_TEXT_2);
                            this.selSystem = identifyLEDEnclosureBean.getSelectedSystem();
                            identifyLEDFruBean.setSelectedSystem(this.selSystem);
                            String string6 = identifyLEDEnclosureBean.getSelectedEnclosure();
                            identifyLEDFruBean.setSelectedEnclosure(string6);
                            String string7 = identifyLEDEnclosureBean.getSelectedEnclosureLocationCode();
                            ArrayList arrayList = identifyLEDEnclosureBean.getEnclosureIdentifyLEDStruct();
                            ArrayList arrayList2 = null;
                            IdentifyLEDStruct identifyLEDStruct = null;
                            for (int i = 0; i < arrayList.size(); ++i) {
                                identifyLEDStruct = (IdentifyLEDStruct)arrayList.get(i);
                                String string8 = identifyLEDStruct.getLocCode();
                                if (!string8.equals(string7)) continue;
                                arrayList2 = identifyLEDStruct.getFRUList();
                                break;
                            }
                            if (arrayList2 != null && arrayList2.size() > 0) {
                                this.setDescriptions(arrayList2, this.selSystem, 1);
                                identifyLEDFruBean.setEnclosureIdentifyLEDStruct(arrayList);
                                identifyLEDFruBean.setFruIdentifyLEDStruct(arrayList2);
                            }
                            identifyLEDFruBean.setEnclosureBean(identifyLEDEnclosureBean);
                            identifyLEDFruBean.setSelectedEnclosureLocationCode(string7);
                            panelTaskletResponse.openModalChild(AUIML_FILE_NAME, FRU_PANEL, (PanelBean)identifyLEDFruBean);
                            this.destroyBusyDialog();
                        }
                        catch (Exception exception) {
                            Trace.trace((String)TRACE_MASKD, (Object)("-- exception occurred while attempting to launch FRU dialog, e is " + exception));
                            try {
                                this.destroyBusyDialog();
                                new AusMicrocodeLog(_logInfo, 65, exception).writeEntry(null);
                                SFPUtil.showSFPErrorMessageBox("0245", (PanelTasklet)this);
                                panelTaskletResponse.openModalChild(AUIML_FILE_NAME, FRU_PANEL, (PanelBean)identifyLEDFruBean);
                            }
                            catch (Exception exception3) {
                                Trace.trace((String)TRACE_MASKF, (Object)("Another exception caught during request, e1 is " + exception3));
                                panelTaskletResponse.noAction();
                            }
                        }
                    } else {
                        Trace.trace((String)TRACE_MASKF, (Object)"Unknown command");
                        panelTaskletResponse.noAction();
                    }
                } else if (string3.equals(FRU_PANEL)) {
                    IdentifyLEDFruBean identifyLEDFruBean = (IdentifyLEDFruBean)panelTaskletRequest.getData("DataBean");
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("Command", string);
                    hashMap.put("Source", string3);
                    hashMap.put("DataBean", identifyLEDFruBean);
                    if (string == null) {
                        string = "";
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)("--> command=" + string));
                    if (string.equals("")) {
                        Trace.trace((String)TRACE_MASKF, (Object)"Unspecified command");
                        panelTaskletResponse.noAction();
                    } else if (string.equals("RefreshFRUPanelButton")) {
                        try {
                            Cloneable cloneable;
                            Object object;
                            this.showBusyDialog(BUSY_LED_TITLE_1, BUSY_LED_TEXT_2);
                            ArrayList arrayList = this.getAllEnclosureInfo(this.userDefinedName);
                            if (arrayList != null && arrayList.size() > 0) {
                                this.setDescriptions(arrayList, this.selSystem, 0);
                                object = identifyLEDFruBean.getSelectedEnclosureLocationCode();
                                cloneable = null;
                                IdentifyLEDStruct identifyLEDStruct = null;
                                for (int i = 0; i < arrayList.size(); ++i) {
                                    identifyLEDStruct = (IdentifyLEDStruct)arrayList.get(i);
                                    String string9 = identifyLEDStruct.getLocCode();
                                    if (!string9.equals(object)) continue;
                                    cloneable = identifyLEDStruct.getFRUList();
                                    break;
                                }
                                if (cloneable != null && ((ArrayList)cloneable).size() > 0) {
                                    this.setDescriptions((ArrayList)cloneable, this.selSystem, 1);
                                    identifyLEDFruBean.setEnclosureIdentifyLEDStruct(arrayList);
                                    identifyLEDFruBean.setFruIdentifyLEDStruct((ArrayList)cloneable);
                                }
                            }
                            panelTaskletResponse.setMultipleResponseMode();
                            identifyLEDFruBean.setEnclosureIdentifyLEDStruct(arrayList);
                            hashMap.put("DataBean", identifyLEDFruBean);
                            hashMap.put("Command", "refreshFruTable");
                            panelTaskletResponse.update("IdentifyLEDFruBean", hashMap);
                            object = identifyLEDFruBean.getEnclosureBean();
                            ((IdentifyLEDEnclosureBean)object).setEnclosureIdentifyLEDStruct(arrayList);
                            cloneable = new HashMap();
                            ((HashMap)cloneable).put("DataBean", object);
                            ((HashMap)cloneable).put("Command", "refreshEnclTable");
                            panelTaskletResponse.update("IdentifyLEDEnclosureBean", (Object)cloneable);
                            this.destroyBusyDialog();
                        }
                        catch (Exception exception) {
                            Trace.trace((String)TRACE_MASKD, (Object)("-- unexpected exception querying LED states: " + exception));
                            Trace.trace((String)TRACE_MASKF, (Object)exception);
                            try {
                                this.destroyBusyDialog();
                                new AusMicrocodeLog(_logInfo, 65, exception).writeEntry(null);
                                String string10 = exception.getMessage().equals("CIMNullClient") ? "0242" : (exception instanceof UnknownHostException ? "0241" : (exception instanceof PIHscClientException ? "0243" : "0245"));
                                SFPUtil.showSFPErrorMessageBox(string10, (PanelTasklet)this);
                            }
                            catch (TaskletException taskletException) {
                                Trace.trace((String)TRACE_MASKD, (Object)("-- exception destroying busy dialog: " + (Object)((Object)taskletException)));
                            }
                            panelTaskletResponse.noAction();
                        }
                    } else if (string.equals("ActivateFRULEDButton")) {
                        String[] stringArray = identifyLEDFruBean.getSelectedFruLocationCodes();
                        ArrayList arrayList = identifyLEDFruBean.getFruIdentifyLEDStruct();
                        this.serviceIdentifyLEDFruCmd(stringArray, arrayList, 1);
                        String string11 = identifyLEDFruBean.getSelectedEnclosureLocationCode();
                        ArrayList arrayList3 = identifyLEDFruBean.getEnclosureIdentifyLEDStruct();
                        this.showBusyDialog(BUSY_LED_TITLE_1, BUSY_LED_TEXT_5);
                        this.updateILS(arrayList3, string11);
                        panelTaskletResponse.setMultipleResponseMode();
                        identifyLEDFruBean.setEnclosureIdentifyLEDStruct(arrayList3);
                        hashMap.put("DataBean", identifyLEDFruBean);
                        hashMap.put("Command", "refreshFruTable");
                        panelTaskletResponse.update("IdentifyLEDFruBean", hashMap);
                        IdentifyLEDEnclosureBean identifyLEDEnclosureBean = identifyLEDFruBean.getEnclosureBean();
                        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                        hashMap2.put("DataBean", identifyLEDEnclosureBean);
                        hashMap2.put("Command", "refreshEnclTable");
                        panelTaskletResponse.update("IdentifyLEDEnclosureBean", hashMap2);
                        this.destroyBusyDialog();
                    } else if (string.equals("DeactivateFRULEDButton")) {
                        String[] stringArray = identifyLEDFruBean.getSelectedFruLocationCodes();
                        ArrayList arrayList = identifyLEDFruBean.getFruIdentifyLEDStruct();
                        this.serviceIdentifyLEDFruCmd(stringArray, arrayList, 0);
                        String string12 = identifyLEDFruBean.getSelectedEnclosureLocationCode();
                        ArrayList arrayList4 = identifyLEDFruBean.getEnclosureIdentifyLEDStruct();
                        this.showBusyDialog(BUSY_LED_TITLE_1, BUSY_LED_TEXT_5);
                        this.updateILS(arrayList4, string12);
                        panelTaskletResponse.setMultipleResponseMode();
                        identifyLEDFruBean.setEnclosureIdentifyLEDStruct(arrayList4);
                        hashMap.put("DataBean", identifyLEDFruBean);
                        hashMap.put("Command", "refreshFruTable");
                        panelTaskletResponse.update("IdentifyLEDFruBean", hashMap);
                        IdentifyLEDEnclosureBean identifyLEDEnclosureBean = identifyLEDFruBean.getEnclosureBean();
                        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
                        hashMap3.put("DataBean", identifyLEDEnclosureBean);
                        hashMap3.put("Command", "refreshEnclTable");
                        panelTaskletResponse.update("IdentifyLEDEnclosureBean", hashMap3);
                        this.destroyBusyDialog();
                    } else {
                        Trace.trace((String)TRACE_MASKF, (Object)"Unknown command");
                        panelTaskletResponse.noAction();
                    }
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)"Unknown tasklet request sent to IdentifyLEDTasklet.");
                    panelTaskletResponse.noAction();
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- IdentifyLEDTasklet.service()");
    }

    private void setDescriptions(ArrayList arrayList, String string, int n) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> IdentifyLEDTasklet.setDescriptions()");
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        Trace.trace((String)TRACE_MASKF, (Object)("-- input ILS array size is " + arrayList.size()));
        IdentifyLEDStruct identifyLEDStruct = (IdentifyLEDStruct)arrayList.get(0);
        String string2 = identifyLEDStruct.getDescription();
        if (string2 != null && string2.length() != 0) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- found prior descriptions already set (" + string2 + ") - bypass routine"));
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)("-- mtms for FruConfig constructor is <" + string + ">"));
            try {
                String string3 = string.substring(0, 4);
                String string4 = string.substring(5, 8);
                FruConfig fruConfig = new FruConfig(string3, string4);
                for (int i = 0; i < arrayList.size(); ++i) {
                    identifyLEDStruct = (IdentifyLEDStruct)arrayList.get(i);
                    stringArray[0] = identifyLEDStruct.getLocCode();
                    if (n == 1) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- Fru " + i + " locCode is <" + stringArray[0] + ">"));
                    } else {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- Enclosure " + i + " locCode is <" + stringArray[0] + ">"));
                    }
                    stringArray2 = fruConfig.queryDescriptionsByLocation(stringArray, null);
                    if (stringArray2 == null || stringArray2[0].length() == 0) {
                        stringArray2[0] = n == 1 ? "unknown_fru" : "unknown_enclosure";
                    }
                    if (n == 1) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- FRU description for " + stringArray[0] + " is <" + stringArray2[0] + ">"));
                    } else {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- Enclosure description for " + stringArray[0] + " is <" + stringArray2[0] + ">"));
                    }
                    identifyLEDStruct.setDescription(stringArray2[0]);
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected FruConfig exception caught, e is <" + exception + ">"));
                Trace.trace((String)TRACE_MASKF, (Object)exception);
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- IdentifyLEDTasklet.setDescriptions()");
    }

    private void updateILS(ArrayList arrayList, String string) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> IdentifyLEDTasklet.updateILS()");
        Trace.trace((String)TRACE_MASKF, (Object)("-- input locCode is " + string));
        for (int i = 0; i < arrayList.size(); ++i) {
            IdentifyLEDStruct identifyLEDStruct = (IdentifyLEDStruct)arrayList.get(i);
            String string2 = identifyLEDStruct.getLocCode();
            if (!string2.equals(string)) continue;
            Trace.trace((String)TRACE_MASKF, (Object)"-- enclosure locCode match found");
            try {
                Vector vector = null;
                vector = this.TargetIsACec ? this.r5Client.getIdentifyLEDUnderEnclosure(string2) : this.r5fClient.getIdentifyLEDUnderEnclosure(string2);
                if (vector != null && vector.size() > 0) {
                    Trace.trace((String)TRACE_MASKF, (Object)("-- number of PILEDDataBeans returned is " + vector.size()));
                    ArrayList arrayList2 = identifyLEDStruct.getFRUList();
                    for (int j = 0; j < vector.size(); ++j) {
                        PILEDDataBean pILEDDataBean = (PILEDDataBean)vector.elementAt(j);
                        Integer[] integerArray = pILEDDataBean.getLEDStates();
                        if (j == 0) {
                            identifyLEDStruct.setState(integerArray[0]);
                            continue;
                        }
                        IdentifyLEDStruct identifyLEDStruct2 = (IdentifyLEDStruct)arrayList2.get(j - 1);
                        identifyLEDStruct2.setState(integerArray[0]);
                    }
                    break;
                }
                Trace.trace((String)TRACE_MASKF, (Object)"-- vector returned from getIdentifyLEDUnderEnclosure() call is null or 0 lengtyh");
                break;
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught. e is " + exception));
                Trace.trace((String)TRACE_MASKF, (Object)exception);
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- IdentifyLEDTasklet.updateILS()");
    }

    private boolean IsFruLedLit(String string) {
        boolean bl;
        block5: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> IdentifyLEDTasklet.IsFruLedLit()");
            bl = false;
            try {
                Vector vector = null;
                vector = this.TargetIsACec ? this.r5Client.getIdentifyLEDUnderEnclosure(string) : this.r5fClient.getIdentifyLEDUnderEnclosure(string);
                if (vector == null || vector.size() <= 0) break block5;
                Trace.trace((String)TRACE_MASKF, (Object)("-- number of PILEDDataBeans returned is " + vector.size()));
                for (int i = 0; i < vector.size(); ++i) {
                    PILEDDataBean pILEDDataBean = (PILEDDataBean)vector.elementAt(i);
                    Integer[] integerArray = pILEDDataBean.getLEDStates();
                    if (i <= 0 || integerArray[0] != 1) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught. e is " + exception));
                Trace.trace((String)TRACE_MASKF, (Object)exception);
            }
        }
        if (bl) {
            Trace.trace((String)TRACE_MASKF, (Object)"-- at least one Fru has it's LED lit");
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"-- no Frus have their LEDs active.");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- IdentifyLEDTasklet.IsFruLedLit()");
        return bl;
    }

    private void serviceIdentifyLEDEnclosureCmd(String string, int n) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> IdentifyLEDTasklet.serviceIdentifyLEDEnclosureCmd()");
        try {
            this.showBusyDialog(BUSY_LED_TITLE_2, BUSY_LED_TEXT_3);
            Trace.trace((String)TRACE_MASKF, (Object)("-- parms to setIdentifyLEDStates are: " + string + " and " + n));
            String[] stringArray = new String[]{string};
            Integer[] integerArray = new Integer[]{new Integer(n)};
            Integer[] integerArray2 = new Integer[]{new Integer(2)};
            if (this.TargetIsACec) {
                this.r5Client.setIdentifyLEDStates(stringArray, integerArray, integerArray2);
            } else {
                this.r5fClient.setIdentifyLEDs(stringArray, integerArray, integerArray2);
            }
            try {
                this.destroyBusyDialog();
                SFPUtil.showSFPInfoMessageBox("0105", (PanelTasklet)this);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKD, (Object)("-- exception launching message box: " + exception));
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking the setIdentifyLEDStates() cmd. Exception is: " + exception));
            Trace.trace((String)TRACE_MASKF, (Object)exception);
            try {
                this.destroyBusyDialog();
                new AusMicrocodeLog(_logInfo, 69, exception).writeEntry(null);
                SFPUtil.showSFPErrorMessageBox("0129", (PanelTasklet)this);
            }
            catch (TaskletException taskletException) {
                Trace.trace((String)TRACE_MASKD, (Object)("-- exception destroying busy dialog: " + (Object)((Object)taskletException)));
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- IdentifyLEDTasklet.serviceIdentifyLEDEnclosureCmd()");
    }

    private void serviceIdentifyLEDFruCmd(String[] stringArray, ArrayList arrayList, int n) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> IdentifyLEDTasklet.serviceIdentifyLEDFRUCmd()");
        try {
            this.showBusyDialog(BUSY_LED_TITLE_2, BUSY_LED_TEXT_4);
            Trace.trace((String)TRACE_MASKF, (Object)("-- number of selected slots is is: " + stringArray.length));
            String[] stringArray2 = new String[stringArray.length];
            Integer[] integerArray = new Integer[stringArray.length];
            Integer[] integerArray2 = new Integer[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                integerArray[i] = new Integer(n);
                integerArray2[i] = new Integer(2);
                String string = stringArray[i];
                Trace.trace((String)TRACE_MASKF, (Object)("-- selected loc code is <" + string + ">"));
                Integer n3 = null;
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    IdentifyLEDStruct identifyLEDStruct = (IdentifyLEDStruct)arrayList.get(n2);
                    String string2 = identifyLEDStruct.getLocCode();
                    if (!string2.equals(string)) continue;
                    n3 = identifyLEDStruct.getStatus();
                    break;
                }
                if (n3 != null) {
                    n2 = n3;
                    if ((n2 & 0xC) == 0 || (n2 & 0xC0) == 192) {
                        int n4 = string.lastIndexOf("-");
                        if (n4 != -1) {
                            Trace.trace((String)TRACE_MASKF, (Object)"-- using parent location code...");
                            stringArray2[i] = string.substring(0, n4);
                        } else {
                            Trace.trace((String)TRACE_MASKF, (Object)"-- problem determining parent loc code, using original...");
                            stringArray2[i] = string;
                        }
                    } else {
                        Trace.trace((String)TRACE_MASKF, (Object)"-- status indicate an implemented indicator, using original loc code...");
                        stringArray2[i] = string;
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)("-- parms for selection[" + i + "], setIdentifyLEDStates are: " + stringArray2[i] + " and " + integerArray[i]));
                    continue;
                }
                Trace.trace((String)TRACE_MASKF, (Object)"-- selFruStatus still null");
                stringArray2[i] = string;
            }
            if (this.TargetIsACec) {
                this.r5Client.setIdentifyLEDStates(stringArray2, integerArray, integerArray2);
            } else {
                this.r5fClient.setIdentifyLEDs(stringArray2, integerArray, integerArray2);
            }
            try {
                this.destroyBusyDialog();
                SFPUtil.showSFPInfoMessageBox("0105", (PanelTasklet)this);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKD, (Object)("-- exception launching message box: " + exception));
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking the setIdentifyLEDStates() cmd. Exception is: " + exception));
            Trace.trace((String)TRACE_MASKF, (Object)exception);
            try {
                this.destroyBusyDialog();
                new AusMicrocodeLog(_logInfo, 70, exception).writeEntry(null);
                SFPUtil.showSFPErrorMessageBox("0104", (PanelTasklet)this);
            }
            catch (TaskletException taskletException) {
                Trace.trace((String)TRACE_MASKD, (Object)("-- exception display msg box: " + (Object)((Object)taskletException)));
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- IdentifyLEDTasklet.serviceIdentifyLEDFRUCmd()");
    }

    public ArrayList getAllEnclosureInfo(String string) throws Exception {
        ArrayList arrayList;
        block9: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> IdentifyLEDTasklet.getAllEnclosureInfo()");
            arrayList = null;
            Trace.trace((String)TRACE_MASKF, (Object)("-- input sysName is: " + string));
            try {
                if (this.r5Client == null || this.r5fClient == null) {
                    if (this.TargetIsACec) {
                        this.r5Client = this.createCECClient(string);
                    } else {
                        this.r5fClient = this.createFrameClient(string);
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)"-- CIM client value should now be set");
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- CIM client instance has already been set");
                }
                if (this.r5Client != null || this.r5fClient != null) {
                    try {
                        arrayList = this.TargetIsACec ? this.getAllCECSysInfo(this.r5Client) : this.getAllFrameSysInfo(this.r5fClient);
                        Trace.trace((String)TRACE_MASKF, (Object)"-- getAllSysInfo() completed successfully");
                        break block9;
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught during getAllSysInfo(), exception is: " + exception));
                        Trace.trace((String)TRACE_MASKF, (Object)exception);
                        new AusMicrocodeLog(_logInfo, 66, exception).writeEntry(null);
                        throw exception;
                    }
                }
                Trace.trace((String)TRACE_MASKF, (Object)"-- could not create the CEC CIM client");
                new AusMicrocodeLog(_logInfo, 67).writeEntry(null);
                throw new Exception("CIMNullClient");
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, rethrowing..." + exception));
                new AusMicrocodeLog(_logInfo, 68, exception).writeEntry(null);
                throw exception;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- IdentifyLEDTasklet.getAllEnclosureInfo()");
        return arrayList;
    }

    private PIHSCCECClient createCECClient(String string) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> IdentifyLEDTasklet.createCECClient()");
        PIHSCCECClient pIHSCCECClient = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            Trace.trace((String)TRACE_MASKF, (Object)("-- theHostName is: " + string2));
            try {
                PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, null);
                Trace.trace((String)TRACE_MASKD, (Object)("-- selected system name is: " + string));
                pIHSCCECClient = pIHSCClientObjectFactory.createCECClient(string, false);
                if (null == pIHSCCECClient) {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- Cannot create PIHSCCECClient - client is null");
                    try {
                        throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "MANAGED_SYSTEM_NOT_FOUND", null, null);
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- Could not throw new PIHscClientException, exception is: " + exception));
                        throw exception;
                    }
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception building the r5Client is: " + exception));
                throw exception;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- no HMC hostname, Exception is: " + unknownHostException));
            throw unknownHostException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- IdentifyLEDTasklet.createCECClient()");
        return pIHSCCECClient;
    }

    private PIHSCFrameClient createFrameClient(String string) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> IdentifyLEDTasklet.createFrameClient()");
        PIHSCFrameClient pIHSCFrameClient = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            Trace.trace((String)TRACE_MASKF, (Object)("-- theHostName is: " + string2));
            try {
                PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, null);
                Trace.trace((String)TRACE_MASKD, (Object)("-- selected system name is: " + string));
                pIHSCFrameClient = pIHSCClientObjectFactory.createFrameClient(string, false);
                if (null == pIHSCFrameClient) {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- Cannot create PIHSCFrameClient - client is null");
                    try {
                        throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "MANAGED_SYSTEM_NOT_FOUND", null, null);
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- Could not throw new PIHscClientException, exception is: " + exception));
                        throw exception;
                    }
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception building the r5fClient is: " + exception));
                throw exception;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- no HMC hostname, Exception is: " + unknownHostException));
            throw unknownHostException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- IdentifyLEDTasklet.createCECClient()");
        return pIHSCFrameClient;
    }

    private ArrayList getAllCECSysInfo(PIHSCCECClient pIHSCCECClient) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> IdentifyLEDTasklet.getAllCECSysInfo()");
        PILEDDataBean pILEDDataBean = null;
        ArrayList<IdentifyLEDStruct> arrayList = null;
        try {
            String string = this.selSystem.substring(0, 4);
            pILEDDataBean = pIHSCCECClient.getAllHardwareInfo();
            String[] stringArray = pILEDDataBean.getEnclosures();
            String[] stringArray2 = pILEDDataBean.getLocationCodes();
            Integer[] integerArray = pILEDDataBean.getLEDStatus();
            Integer[] integerArray2 = pILEDDataBean.getLEDStates();
            String string2 = null;
            if (stringArray != null && stringArray.length > 0) {
                arrayList = new ArrayList<IdentifyLEDStruct>();
                IdentifyLEDStruct identifyLEDStruct = null;
                ArrayList<IdentifyLEDStruct> arrayList2 = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals(ENCL)) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- encloure marker detected at index: " + i));
                        string2 = stringArray2[i].substring(1, 5);
                        if (string2.equals(string)) {
                            Trace.trace((String)TRACE_MASKF, (Object)("-- system returned as an enclosure detected at index: " + i));
                        }
                        arrayList2 = new ArrayList<IdentifyLEDStruct>();
                        identifyLEDStruct = new IdentifyLEDStruct(stringArray2[i], integerArray2[i], integerArray[i], null, arrayList2);
                        arrayList.add(identifyLEDStruct);
                    } else if (stringArray[i].equals(SYS_TAG)) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- found the system identifier marker at index: " + i));
                    } else {
                        IdentifyLEDStruct identifyLEDStruct2 = new IdentifyLEDStruct(stringArray2[i], integerArray2[i], integerArray[i], null, null);
                        arrayList2.add(identifyLEDStruct2);
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)("locCode/status/state is <" + stringArray2[i] + "/" + integerArray[i] + "/" + integerArray2[i] + ">"));
                }
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking getAllHardwareInfo() cmd. Exception is: " + exception));
            throw exception;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- IdentifyLEDTasklet.getAllCECSysInfo()");
        return arrayList;
    }

    private ArrayList getAllFrameSysInfo(PIHSCFrameClient pIHSCFrameClient) throws Exception {
        ArrayList<IdentifyLEDStruct> arrayList;
        block11: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> IdentifyLEDTasklet.getAllFrameSysInfo()");
            PILEDDataBean pILEDDataBean = null;
            arrayList = null;
            Vector vector = null;
            ArrayList<IdentifyLEDStruct> arrayList2 = null;
            try {
                String string = this.selSystem.substring(0, 4);
                vector = pIHSCFrameClient.getAllLocationCodes();
                if (vector != null && vector.size() > 0) {
                    arrayList = new ArrayList<IdentifyLEDStruct>();
                    for (int i = 0; i < vector.size(); ++i) {
                        pILEDDataBean = (PILEDDataBean)vector.elementAt(i);
                        String[] stringArray = pILEDDataBean.getEnclosures();
                        String[] stringArray2 = pILEDDataBean.getLocationCodes();
                        Integer[] integerArray = pILEDDataBean.getLEDStatus();
                        Integer[] integerArray2 = pILEDDataBean.getLEDStates();
                        String string2 = null;
                        if (stringArray != null && stringArray.length > 0) {
                            IdentifyLEDStruct identifyLEDStruct = null;
                            for (int j = 0; j < stringArray.length; ++j) {
                                if (stringArray[j].equals(ENCL)) {
                                    arrayList2 = null;
                                    Trace.trace((String)TRACE_MASKF, (Object)("-- encloure marker detected at index: " + j));
                                    string2 = stringArray2[j].substring(1, 5);
                                    if (string2.equals(string)) {
                                        Trace.trace((String)TRACE_MASKF, (Object)("-- system returned as an enclosure detected at index: " + j));
                                    }
                                    arrayList2 = new ArrayList<IdentifyLEDStruct>();
                                    identifyLEDStruct = new IdentifyLEDStruct(stringArray2[j], integerArray2[j], integerArray[j], null, arrayList2);
                                    arrayList.add(identifyLEDStruct);
                                } else if (stringArray[j].equals(SYS_TAG)) {
                                    Trace.trace((String)TRACE_MASKF, (Object)("-- found the system identifier marker at index: " + j));
                                } else {
                                    IdentifyLEDStruct identifyLEDStruct2 = new IdentifyLEDStruct(stringArray2[j], integerArray2[j], integerArray[j], null, null);
                                    arrayList2.add(identifyLEDStruct2);
                                }
                                Trace.trace((String)TRACE_MASKF, (Object)("locCode/status/state is <" + stringArray2[j] + "/" + integerArray[j] + "/" + integerArray2[j] + ">"));
                            }
                            continue;
                        }
                        Trace.trace((String)TRACE_MASKF, (Object)("-- PILEDDataBean[" + i + "] enclosure is null or length = 0."));
                    }
                    break block11;
                }
                Trace.trace((String)TRACE_MASKF, (Object)"-- no PILEDDataBeans returned from getAllLocationCodes() call.");
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking getAllHardwareInfo() cmd. Exception is: " + exception));
                throw exception;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- IdentifyLEDTasklet.getAllFrameSysInfo()");
        return arrayList;
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> IdentifyLEDTasklet.logException()");
        Trace.trace((String)TRACE_MASKT, (Object)("processing exception: " + throwable));
        HException hException = new HException(throwable);
        new AusMicrocodeLog(_logInfo, 64, hException).writeEntry(null);
        Trace.trace((String)TRACE_MASKT, (Object)"<- IdentifyLEDTasklet.logException()");
    }
}

